// Copyright (c) 2013 Analog Devices, Inc.  All rights reserved.

// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions are met:
  // - Redistributions of source code must retain the above copyright notice,
  // this list of conditions and the following disclaimer.
  // - Redistributions in binary form must reproduce the above copyright notice,
  // this list of conditions and the following disclaimer in the documentation 
  // and/or other materials provided with the distribution.  
  // - Modified versions of the software must be conspicuously marked as such.
  // - This software is licensed solely and exclusively for use with 
  // processors/products manufactured by or for Analog Devices, Inc.
  // - This software may not be combined or merged with other code in any manner 
  // that would cause the software to become subject to terms and conditions which 
  // differ from those listed here.
  // - Neither the name of Analog Devices, Inc. nor the names of its contributors
  // may be used to endorse or promote products derived from this software without 
  // specific prior written permission.
  // - The use of this software may or may not infringe the patent rights of one
  // or more patent holders.  This license does not release you from the requirement
  // that you obtain separate licenses from these patent holders to use this software.

// THIS SOFTWARE IS PROVIDED BY ANALOG DEVICES, INC. AND CONTRIBUTORS "AS IS" 
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
// NON-INFRINGEMENT, TITLE, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
// ARE DISCLAIMED. IN NO EVENT SHALL ANALOG DEVICES, INC. OR CONTRIBUTORS BE LIABLE
 // FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, PUNITIVE OR 
 // CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, DAMAGES ARISING OUT OF 
 // CLAIMS OF INTELLECTUAL PROPERTY RIGHTS INFRINGEMENT; PROCUREMENT OF SUBSTITUTE
 // GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 // HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 // LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 // OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

// 20180927-7CBSD SLA

`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer: 
// 
// Create Date:    10:06:19 09/24/2013 
// Design Name: 
// Module Name:    data_capture 
// Project Name: 
// Target Devices: 
// Tool versions: 
// Description: 
//
// Dependencies: 
//
// Revision: 
// Revision 0.01 - File Created
// Additional Comments: 
//
//////////////////////////////////////////////////////////////////////////////////
module sar_data_capture #(
								parameter normal_count_1 = 5'd16,
								parameter normal_count = 5'd17,
								parameter status_count_1 = 5'd22,
								parameter status_count = 5'd23
	)
	(
	reset,
	sys_clk,
	adc_clk_in,
	adc_data_in,
	new_data,
	data_received,
	status_en
    );


	input			reset;
	input			sys_clk;
	input			adc_clk_in;
	input			adc_data_in;
	output			new_data;//the strobe signal pulse with the recieve data
	output	[status_count:0]	data_received;
	input			status_en;

	reg		[4:0]	shift_counter;
	reg				data_valid;

	reg		[status_count:0]	input_shift_reg;
	reg		[status_count:0]	data_out_reg;

	wire			data_latch;
	reg		[4:0]	shift_number;
	
	assign	data_received = data_out_reg;
	
//	assign   shift_number = status_en? status_count : normal_count;
	
	always @(posedge sys_clk or posedge reset)begin
		if(reset)
			shift_number <= normal_count;
		else if(status_en == 1'b1)begin
			shift_number <= status_count;
		end
		else begin
			shift_number <= normal_count;
		end
	end
// self-clean counter before one cycle
	always @ (negedge adc_clk_in or posedge reset) begin
		if (reset) begin
			shift_counter <= 5'b0;
		end
		else if (shift_counter < shift_number) begin
			shift_counter <= shift_counter + 1'b1;
		end
		else begin
			shift_counter <= 5'b0;
		end		
	end
// generate data ready signal 	
	always @ (negedge adc_clk_in or posedge reset) begin
		if (reset)
			data_valid <= 1'b0;
		else if (shift_counter == shift_number)
			data_valid <= 1'b1;
		else
			data_valid <= 1'b0;
	end
// recieve ADC data	
	always @ (negedge adc_clk_in or posedge reset) begin
		if (reset)
			input_shift_reg <= 24'b0;
		else
			input_shift_reg <= {input_shift_reg[status_count_1:0], adc_data_in};
	end	
// resync data_valid signal to system clock domain
	sync_pulse i_sync_pulse(
		.reset		(reset),
		.pulse_in	(data_valid),
		.sync_clk	(sys_clk),
		.sync_pulse	(data_latch),
		.sync_pulse_delay (new_data)
	);
	
	always @ (posedge sys_clk) begin
		if (data_latch) begin
			data_out_reg <= input_shift_reg;
		end
	end

endmodule
